/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.util.HashSet;
import java.util.Set;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public class OneByOneHoles
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> holeColor;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<Boolean> tracers;
    private final Setting<SettingColor> tracerColor;
    private final Set<class_2338> oneByOneHoles;

    public OneByOneHoles() {
        super(CatalystAddon.esp, "1by1-holes", "Highlights 1by1 air holes that are likely player-made.");
        this.sgGeneral = this.settings.createGroup("General");
        this.holeColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("hole-color")).description("Color for 1by1 holes")).defaultValue(new SettingColor(255, 0, 0, 100)).build());
        this.shapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Render mode for 1by1 holes")).defaultValue((Object)ShapeMode.Both)).build());
        this.tracers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers to 1by1 holes")).defaultValue((Object)false)).build());
        this.tracerColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("1by1 hole tracer color")).defaultValue(new SettingColor(255, 0, 0, 200)).visible(() -> this.tracers.get())).build());
        this.oneByOneHoles = new HashSet<class_2338>();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        this.oneByOneHoles.clear();
        for (class_2791 chunk : Utils.chunks()) {
            if (!(chunk instanceof class_2818)) continue;
            this.scanChunk((class_2818)chunk);
        }
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        this.scanChunk(event.chunk());
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        if (this.isOneByOneHole(pos)) {
            this.oneByOneHoles.add(pos);
            this.mc.field_1724.method_7353(class_2561.method_30163((String)("1by1 hole detected at: " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())), false);
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(direction);
            if (this.isOneByOneHole(neighborPos)) {
                this.oneByOneHoles.add(neighborPos);
                continue;
            }
            this.oneByOneHoles.remove(neighborPos);
        }
    }

    private void scanChunk(class_2818 chunk) {
        for (int x = chunk.method_12004().method_8326(); x < chunk.method_12004().method_8327(); ++x) {
            for (int z = chunk.method_12004().method_8328(); z < chunk.method_12004().method_8329(); ++z) {
                for (int y = chunk.method_31607(); y < chunk.method_31607() + chunk.method_31605(); ++y) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!this.isOneByOneHole(pos)) continue;
                    this.oneByOneHoles.add(pos);
                    this.mc.field_1724.method_7353(class_2561.method_30163((String)("1by1 hole detected at: " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())), false);
                }
            }
        }
    }

    private boolean isOneByOneHole(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return false;
        }
        class_2680 selfState = this.mc.field_1687.method_8320(pos);
        if (pos.method_10264() <= 1) {
            return false;
        }
        if (selfState.method_26204() != class_2246.field_10124) {
            return false;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2680 neighborState = this.mc.field_1687.method_8320(pos.method_10093(direction));
            if (neighborState.method_26212((class_1922)this.mc.field_1687, pos.method_10093(direction))) continue;
            return false;
        }
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    class_2338 checkPos;
                    class_2680 checkState;
                    if (x == 0 && y == 0 && z == 0 || (checkState = this.mc.field_1687.method_8320(checkPos = pos.method_10069(x, y, z))).method_26212((class_1922)this.mc.field_1687, checkPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color side = new Color((Color)this.holeColor.get());
        Color outline = new Color((Color)this.holeColor.get());
        Color tracerColorValue = new Color((Color)this.tracerColor.get());
        for (class_2338 pos : this.oneByOneHoles) {
            class_243 startPos;
            event.renderer.box(pos, side, outline, (ShapeMode)this.shapeMode.get(), 0);
            if (!((Boolean)this.tracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, tracerColorValue);
        }
    }
}

